///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __TARGET_OBJECT_H
#define __TARGET_OBJECT_H

#include <core/Core.h>
#include <core/scene/objects/SceneObject.h>
#include "../StdObjects.h"

namespace StdObjects {

/******************************************************************************
* Simple helper object that is used as target for camera and light objects.  
******************************************************************************/
class STDOBJECTS_DLLEXPORT TargetObject : public SceneObject
{
public:
	/// Default constructor.
	TargetObject(bool isLoading = false) : SceneObject(isLoading) {}

	// From SceneObject:

	/// Asks the object for its validity interval at the given time.
	virtual TimeInterval objectValidity(TimeTicks time) { return TimeForever; }

	/// Makes the object render itself into the viewport. 
	virtual void renderObject(TimeTicks time, ObjectNode* contextNode, Viewport* vp);

	/// Returns the bounding box of the object in local object coordinates. 
	virtual Box3 boundingBox(TimeTicks time, ObjectNode* contextNode) { return Box3(ORIGIN, ORIGIN); }

	/// Do not show selection marker for this target object.
	virtual bool showSelectionMarker() { return false; }
	
private:

	Q_OBJECT
	DECLARE_SERIALIZABLE_PLUGIN_CLASS(TargetObject)
};

};

#endif // __TARGET_OBJECT_H
