///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <scripting/Scripting.h>

#include <core/actions/ActionManager.h>
#include <core/actions/ActionProxy.h>

namespace Scripting {

using namespace boost::python;

void ExportActions()
{
	class_<ActionManager, noncopyable>("ActionManager", no_init)
		.add_static_property("Instance", make_function(&ActionManager::getSingletonInstance, return_value_policy<reference_existing_object>()))
		.def("InvokeAction", &ActionManager::invokeAction)
		.setattr("ACTION_EXIT", ACTION_EXIT)
		.setattr("ACTION_FILE_NEW", ACTION_FILE_NEW)
		.setattr("ACTION_FILE_RESET", ACTION_FILE_RESET)
		.setattr("ACTION_FILE_OPEN", ACTION_FILE_OPEN)
		.setattr("ACTION_FILE_SAVE", ACTION_FILE_SAVE)
		.setattr("ACTION_FILE_SAVEAS", ACTION_FILE_SAVEAS)
		.setattr("ACTION_FILE_IMPORT", ACTION_FILE_IMPORT)
		.setattr("ACTION_FILE_EXPORT", ACTION_FILE_EXPORT)
		.setattr("ACTION_HELP_ABOUT", ACTION_HELP_ABOUT)
		.setattr("ACTION_HELP_SHOW_ONLINE_HELP", ACTION_HELP_SHOW_ONLINE_HELP)
		.setattr("ACTION_EDIT_UNDO", ACTION_EDIT_UNDO)
		.setattr("ACTION_EDIT_REDO", ACTION_EDIT_REDO)
		.setattr("ACTION_EDIT_DELETE", ACTION_EDIT_DELETE)
		.setattr("ACTION_RENDER_ACTIVE_VIEWPORT", ACTION_RENDER_ACTIVE_VIEWPORT)
		.setattr("ACTION_SELECT_RENDERER_DIALOG", ACTION_SELECT_RENDERER_DIALOG)
	;
}

};
