'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS1921-Thermochron 3  2005 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS1921
\- Thermochron temperature logging iButton.
.SH SYNOPSIS
Temperature logging iButton.
.PP
.B 21
[.]XXXXXXXXXXXX[XX][/[
.br
.B about/[measuring| resolution| samples| templow| temphigh| version]
|
.br
.B clock/[date| running| udate]
|
.br
.B histotgram/[counts[0-62|ALL]| gap| temperature[counts[0-62|ALL]]
|
.br
.B log[date[0-2047|ALL]| elements| temperature[0-2047|ALL]| udate[0-2047|ALL]]
|
.br
.B memory
|
.br
.B mission/[date| delay| easystart| frequency| rollover| running| samples| sampling| udate]
|
.br
.B overtemp/[date[0-11|ALL]| elements| end[0-11|ALL]| count[0-11|ALL]| temperature[0-11|ALL]| udate[0-11|ALL]]
|
.br
.B pages/page.[0-15|ALL]
|
.br
.B temperature
|
.br
.B undertemp/[date[0-11|ALL]| elements|end[0-11|ALL]| count[0-11|ALL]| temperature[0-11|ALL]| udate[0-11|ALL]]
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 21
.SH SPECIAL PROPERTIES
.SS about/measuring
.I read-only, yes-no
.br
Is this
.I DS1921
currently
.I measuring
a temperature?
.SS about/resolution
.I read-only, floating point
.br
What is the
.I resolution
of the temperature measurments (in the current temperature scale).
.SS about/samples
.I read-only, unsigned integer
.br
How many total temperature measurements has this
.I DS1921
performed?
.SS about/temphigh
.I read-only, floating point
.br
Highest temperature this
.I DS1921
can measure (in the current temperature scale).
.SS about/templow
.I read-only, floating point
.br
Lowest temperature this
.I DS1921
can measure (in the current temperature scale).
.SS about/version
.I read-only, ascii
.br
Specific
.I version
of this
.I DS1921.
.SS clock/date
.I read-write, ascii
.br
26 character date representation of the internal time stored in this
.I DS1921.
Increments once per second while
.I clock/running
.br
Setting
.I date
to a null string will put the current system time.
.br
Accepted date formats are:
.br
  Sat[urday] March 12 12:23:59 2001
.br
  Apr[il] 4 9:34:56 2002
.br
  3/23/04 23:34:57
.br
  current locale setting (your system's format)
.SS clock/running
.I read-write, yes-no
.br
Whether the internal clock is running. This can be explicitly set, and is automatically started by
setting
.I clock/date
or
.I clock/udate
or by starting a mission with
.I mission/easystart
or
.I mission/frequency
.PP
The main reason to stop the clock is to conserve the internal battery.
The clock cannot be stopped during a mission, and the clock is essential for a mission.
.SS clock/udate
.I read-write, unsigned integer
.br
A numeric representation of
.I clock/date
.br
The number of seconds in UNIX time (since Jan 1, 1970).
.SS histogram/counts.0 ... histogram/counts.62 histogram/counts.ALL
.I read-only, unsigned integer
.br
The number of samples in the current mission whose temperature fell within the
.I histogram/temperature
to
.I histogram/temperature+histogram/gap
range.
.SS histogram/elements
.I read-only, unsigned integer
.br
The number of bins in the histogram. Always 63.
.SS histogram/gap
.I read-only, floating point
.br
The size of the histogram bin. Depends on the Thermochron version (
.I about/version
) and is usually 4 times
.I about/resolution
.PP
Given in the current temperatature scale.
.SS histogram/temperature.0 ... histogram/temperature.62 histogram/temperature.ALL
.I read-only, floating point
.br
Lower limit of the temperature range for the corresponding histogram bin. In the current temperature scale.
.SS log/date.0 ... log/date.2047 log/date.ALL
.I read-only, ascii
.br
Date that the corresponding
.I log/temperature
was taken, in ascii format. (See
.I clock/date
for more on the format).
The number of valid entries is actually
.I log/elements
since the log may not be full.
.PP
.I mission/samples
gives the total number of samples that have been taken but there is only room in the log for 2048 entries.
Once the log is full,
.I mission/rollover
determines the Thermochron's behavior.
.PP
If
.I mission/rollover
is false(0), the log will hold the
.B first
2048 samples and
.I log/date.0
will always be the same as
.I mission/date
.PP
If
.I mission/rollover
is true (1) then the log will hold the
.B last
2048 samples and the entries will be shifted down with each new sample.
.PP
Note the
.I OWFS
code "untwists" the rollover behavior. The data will always be a linear array of earliest to latest.
.PP
.I ALL
is the all data elements comma separated.
.SS log/elements
.I read-only, unsigned integer
.br
Number of valid entries in the log.
.I OWFS
offers the full 2048 values in the log memory, but not that many samples may yet have been taken.
.I log/elements
will range from 0 to 2048 and always be less than or equal to
.I mission/samples
.SS log/temperature.0 ... log/temperature.2047 log/temperature.ALL
.I read-write, floating point
.br
The temperature readings (in the current temperature scale) that correspond to the
.I log/date
sample. See
.I log/date
for details on the indexing scheme and rollover behavior.
.SS log/udate.0 ... log/udate.2047 log/udate.ALL
.I read-write, unsigned integer
.br
A numeric representation of
.I log/date
.br
The number of seconds in UNIX time (since Jan 1, 1970).
.SS memory
.I read-write, binary
.br
User available storage space. 512 bytes. Can also be accessed as 16 pages of 32 bytes with the
.I pages/page.x
properties.
.SS overtemp/count.0 ... overtemp/count.11 overtemp/count.ALL
.SS undertemp/count.0 ... undertemp/count.11 undertemp/count.ALL
.I read-only, unsigned integer
.br
Number of sampling periods that the Thermochron stayed out of range durring a mission. Each sampling period is
.I mission/frequency
minutes long.
.SS overtemp/end.0 ... overtemp/end.11 overtemp/end.ALL
.SS undertemp/end.0 ... undertemp/end.11 undertemp/end.ALL
.I read-only, ascii
.br
End of time that the Thermochron went out of range during the current mission. See
.I clock/date
for format.
.PP
Each period can be up to 255 samples in length, and span the time
.I overtemp/date
to
.I overtemp/end
( or
.I undertemp/date
to
.I undertemp/end
).
.SS overtemp/date.0 ... overtemp/date.11 overtemp/date.ALL
.SS undertemp/date.0 ... undertemp/date.11 undertemp/date.ALL
.I read-only, ascii
.br
Time that the Thermochron went out of range during the current mission. See
.I clock/date
for format.
.SS overtemp/elements
.SS undertemp/elements
.I read-only, unsigned integer
.br
Number of entries (0 to 12) in the
.I overtemp
or
.I undertemp
array.
.SS overtemp/temperature
.SS undertemp/temperature
.I read-write, floating point
.br
Temperature limit to trigger alarm and error log.
.I overtemp/temperature
gives upper limit and 
.I undertemp/temperature
gives lower limit.
.br
In current temperature scale.
.SS overtemp/udate.0 ... overtemp/udate.11 overtemp/udate.ALL
.SS undertemp/udate.0 ... undertemp/udate.11 undertemp/udate.ALL
.I read-only, unsigned integer
.br
A numeric representation of
.I overtemp/date
or
.I undertemp/date
.br
The number of seconds in UNIX time (since Jan 1, 1970).
.SS pages/page.0 ... pages/page.15 pages/page.ALL
.I read-write, binary
.br
Memory is split into 16 pages of 32 bytes each. User available. The log memory, register banks and histogram data area are all separate from this memory area.
.br
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SS temperature
.I read-only, floating point
.br
Last temperature explicitly requested. Only available when the mission is not in progress. Value returned in in the current temperature scale.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS1921 Thermochron
The
.B DS1921 (3)
is an iButton device with many intriguing functions. Essentially it monitors temperature, giving both a log of readings, and a histogram of temperature ranges. The specification is somewhat complex, but OWFS hides many of the implementation details.
.PP
While on a
.I mission
the
.B DS1921 (3)
records temperature readings in a 2048-sample log and adds them to a 62-bin histogram.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2438.pdf
.br
http://pdfserv.maxim-ic.com/en/an/humsensor.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
