'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS2438 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2438
\- Smart Battery Monitor
.SH SYNOPSIS
.SS Temperature Voltages and Current.
.PP
.B 26
[.]XXXXXXXXXXXX[XX][/[
.B CA
|
.B EE
|
.B date
|
.B disconnect/date
|
.B disconnect/udate
|
.B endcharge/date
|
.B endcharge/udate
|
.B IAD
|
.B offset
|
.B pages/page.[0-7|ALL]
|
.B temperature
|
.B latesttemp
|
.B udate
|
.B VAD
|
.B VDD
|
.B vis
|
.so man3/standard_mini.3so
]]
.SS Humidity sensor
.PP
.B 26
[.]XXXXXXXXXXXX[XX][/[
.B HIH4000/humidity
|
.B HTM1735/humidity
|
.B DATANAB/reset
|
.B DATANAB/humidity
|
.B humidity
|
.B temperature
]]
.SS Barometer
.PP
.B 26
[.]XXXXXXXXXXXX[XX][/[
.B B1-R1-A/pressure
|
.B B1-R1-A/gain
|
.B B1-R1-A/offset
|
]]
.SS Light
.PP
.B 26
[.]XXXXXXXXXXXX[XX][/[
.B S3-R1-A/current
|
.B S3-R1-A/illuminance
|
.B S3-R1-A/gain
]]
.SH FAMILY CODE
.PP
.I 26
.SH SPECIAL PROPERTIES
.SS pages/page.0 ... pages/page.7 pages/page.ALL
.I read-write, binary
.br
Memory is split into 8 pages of 8 bytes each. Only the pages 3-7 are really available, and some of that appears to be reserved. See the datasheet for details.
.\" page.3/0 = Multisensor
.\" page.3/2-7 = Hobby Boards Calibration data
.\" page.4 =
.\" page.5 =
.\" page.7/4-7 = current storage
.br
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SS temperature
.I read-only, floating point
.br
.I Temperature
read by the chip at high resolution (~13 bits). Units are selected from the invoking command line. See
.B owfs(1)
or
.B owhttpd(1)
for choices. Default is Celsius.
Conversion takes ~20 msec.
.SS latesttemp
.I read-only, floating point
.br
Latest measured temperature. Reading this node will never trigger a temperature conversion. Intended for use in conjunction with
.B /simultaneous/temperature.
.SS VAD VDD
.I read-only, floating point
.br
Voltage read (~10 bits) at the one of the chip's two supply voltages. Range VDD= 2.4V to 10V, VAD=1.5 to 10V.
.SS vis
.I read-only, floating point
.br
Current sensor reading, as a voltage difference. Value is in volts.
.br
Actual current depends on Rsens resistor (see datasheet).
.br
The formula for current is I = vis / Rsens
.br
with units in Amps and Ohms.
.br
Current measurement will be temporarily enabled (see
.I Ienable
) if not currently enabled (pun intended) for this reading.
.SH CONFIGURATION PROPERTIES
.SS CA
.I read-write, yes-no
.br
.I Current Accumulator Configuration
flag bit. If "on" (1) current is stored in page 7 bytes 4-7. If "off" (0) that page can be used for general storage. See the datasheet for more information.
.SS EE
.I read-write, yes-no
.br
.I Current Accumulator Shadow
flag bit. If "on" (1) current reading is stored to EEPROM. If "off" (0) that data will be lost when chip loses power. See the datasheet for more information
.SS IAD
.I read-write, yes-no
.br
.I Current A/D Control
flag bit. If "on" (1) current measured at 36.41 Hz. If "off" (0) current measurements won't be made. See the datasheet for more information.
.SH DATE PROPERTIES
.SS date
.I read-write, ascii
.br
26 character date representation of the
.I counter
value. Increments once per second.
.br
Setting
.I date
to a null string will put the current system time.
.br
Accepted date formats are:
.br
  Sat[urday] March 12 12:23:59 2001
.br
  Apr[il] 4 9:34:56 2002
.br
  3/23/04 23:34:57
.br
  current locale setting (your system's format)
.SS disconnect/date
.I read-write, ascii
.br
26 character date representation of the
.I disconnect/udate
value. Time when the battery pack waws removed from the charger. Format is the same as the 
.I date
property.
.SS disconnect/udate
.I read-write, unsigned integer
.br
Representation of
.I disconnect/date
as a number. See
.I udate
for details.
.SS endcharge/date
.I read-write, ascii
.br
26 character date representation of the
.I endcharge/udate
value. Format is the same as the 
.I date
property.
.SS endcharge/udate
.I read-write, unsigned integer
.br
Representation of
.I endcharge/date
as a number. See
.I udate
for details.
.SS udate
.I read-write, unsigned integer
.br
Time represented as a number.
.I udate
increments once per second.
.br
Usually set to unix time standard: number of seconds since Jan 1, 1970. The
.I date
field will be the unix representation (ascii text) of
.I udate
and setting either will change the other.
.SH HUMIDITY PROPERTIES
.SS HIH4000/humidity
.I read-only, floating point
.br
Relative humidity, as percent (1-100 scale).
.br
This value is for a design based on Honeywell's HIH-4000 humidity sensor.
.SS HTM1735/humidity
.I read-only, floating point
.br
Relative humidity, as percent (1-100 scale).
.br
This value is for a design based on Humirel's HTM-1735 humidity sensor.
.SS DATANAB/humidity
.I read-only, floating point
.br
Based on DataNAB's humidity sensor. It uses a HIH-4000 sensor and the current sensning rather than voltage readings from the DS2438. Calibration values are stored on chip, and a check field is stored in chip memory.
.SS DATANAB/reset
.I write-only, yes-no
.br
Used to read calibration values and set the chip to current reading more. Should be automatically called when a humidity reading is requested.
.SS humidity
.I read-only, floating point
.br
Relative humidity, as percent (1-100 scale).
.br
The
.B DS2438
actually does not read humidity, but a widely available and publicised circuit based on the chip, does. This design is for the common Honeywell HIH-3610 humidity chip. The mostly compatible HIH-4000 chip uses different temperature compensation, so is better read from the 
.I HIH4000/humidity
value. See the datasheets for details.
.br
If the chip is instead a DATANAB design, the
.I DATANAB/humidity
value will be automatically used.
.SH BAROMETER PROPERTIES
.SS B1-R1-A/pressure
.I read-only, floating point
.br
Pressure reading, as milli-bars, or other unit depending on
.IR settings/units/pressure_scale .
.br
This value is for the B1-R1-A barometer from Hobby-Boards, and
assumes the standard calibration.
.SS B1-R1-A/gain
.I read/write, floating point
.br
Calibration of pressure gain, as signed number, expressed as the same units as
.I B1-R1-A/pressure
per volt.
.br
This value will be multiplied with the measured voltage to get the
.I B1-R1-A/pressure
reading. It may have to be fine tuned for calibration purposes, although with the standard
sensor, it will often be good enough to keep it as is.
.SS B1-R1-A/offset
.I read/write, floating point
.br
Calibration of pressure offset, as signed number, same units as
.I B1-R1-A/pressure.
.br
This value will be added to the 
.I B1-R1-A/pressure
reading. The default value is 904.7 millibars, which may be altered to
to compensate for elevation.
.SH SOLAR SENSOR PROPERTIES
.SS S3-R1-A/current
.I read-only, floating point
.br
Photo-diode current, in micro-amperes.
.br
This value is for the S3-R1-A solar radiation sensor from Hobby-Boards.
Due to noise and offsets, this value may read as a negative number in low light conditions.
The
.I offset
register can be modified to reduce the offset as much as possible.
.SS S3-R1-A/illumination
.I read-only, floating point
.br
Illumination, in lux. Always a positive number.
.br
This value is the lux reading from the solar sensor, taking
.I S3-R1-A/gain into consideration.
.SS S3-R1-A/gain
.I read/write, floating point
.br
Calibration of photo-diode gain expressed as lux per micro-amperes.
The default value is for the SFH203P photo-diode from Osram, used bare.
A different gain may be used for instance to compensate for an integrathing, 
white sphere placed over the diode.
.br
This value is for the S3-R1-A solar radiation sensor from Hobby-Boards,
using the SFH203P photo-diode from Osram.
.SH MULTISENSOR PROPERTIES
.SS MultiSensor/type
.I read-only, ascii
.br
For
.I iButtonLink's MultiSensor
line of 1-wire devices, give the specific configuration based on a data byte set in memory. (Byte 0 of page 3).
This can help interpretation of the sensor values, distinguishing, current from water from light.
.SS offset
.I read-write, integer
.br
Correction for
.I current
readings. A value between \-256 and 255. See the datasheet for details. Should be set to the negative of a true zero
.I current
reading.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2438
The
.B DS2438 (3)
is a more complete form of the
.B DS2436
battery chip. Current sensing is available, but not implemented. The major advantage compared to the
.B DS2436
is that two voltages can be read, allowing one to correct circuit measurements for supply voltage and temperature. A better comparison is the 
.B DS276x
family of chips.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2438.pdf
.br
http://pdfserv.maxim-ic.com/en/an/humsensor.pdf
.br
http://goo.gl/o9DH0 (Redirects to 009012_2.pdf PDF file on honeywell.com website)
.br
http://www.phanderson.com/hih-4000.pdf
.br
http://www.humirel.com/product/fichier/HTM1735%20RevG%20.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
Egil Kvaleberg
