'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\"
.TH DS2437 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2437
\- Smart Battery Monitor
.SH SYNOPSIS
Temperature Voltages and Memory.
.PP
.B 1E
[.]XXXXXXXXXXXX[XX][/[
.B current
|
.B date
|
.B disconnect/date
|
.B disconnect/udate
|
.B endcharge/date
|
.B endcharge/udate
|
.I Ienable
|
.B pages/page.[0-7|ALL]
|
.B temperature
|
.B udate
|
.B VAD
|
.B VDD
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 1E
.SH SPECIAL PROPERTIES
.SS date
.I read-write, ascii
.br
26 character date representation of the
.I counter
value. Increments once per second.
.br
Setting
.I date
to a null string will put the current system time.
.br
Accepted date formats are:
.br
  Sat[urday] March 12 12:23:59 2001
.br
  Apr[il] 4 9:34:56 2002
.br
  3/23/04 23:34:57
.br
  current locale setting (your system's format)
.SS current
.I read-only, integer
.br
Current reading. Actual current depends on Rsens resistor (see datasheet).
.br
The formula for current is I =
.I current
/(4096*Rsens)
.br
with units in Amps and Ohms.
.br
Current measurement will be temporarily enabled (see
.I Ienable
) if not currently enabled (pun intended) for this reading.
.SS disconnect/date
.I read-write, ascii
.br
26 character date representation of the
.I disconnect/udate
value. Time when the battery pack waws removed from the charger. Format is the same as the 
.I date
property.
.SS disconnect/udate
.I read-write, unsigned integer
.br
Representation of
.I disconnect/date
as a number. See
.I udate
for details.
.SS endcharge/date
.I read-write, ascii
.br
26 character date representation of the
.I endcharge/udate
value. Format is the same as the 
.I date
property.
.SS endcharge/udate
.I read-write, unsigned integer
.br
Representation of
.I endcharge/date
as a number. See
.I udate
for details.
.SS Ienable
.I read-write, unsigned integer
.br
Status of
.I current
monitoring. When enabled, current sensing is performed 36.41 times/second. Values of
.I Ienable
are:
.TP
.B 0
no current conversion
.TP
.B 1
current conversion enabled
.TP
.B 2
current conversion and accumulation
.TP
.B 3
current conversion and accumulation with EEPROM backup
.SS pages/page.0 ... pages/page.7 pages/page.ALL
.I read-write, binary
.br
Memory is split into 8 pages of 8 bytes each. Only the pages 3-7 are really available, and some of that appears to be reserved. See the datasheet for details.
.br
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SS temperature
.I read-only, floating point
.br
.I Temperature
read by the chip at high resolution (~13 bits). Units are selected from the invoking command line. See
.B owfs(1)
or
.B owhttpd(1)
for choices. Default is Celsius.
Conversion takes ~20 msec.
.SS udate
.I read-write, unsigned integer
.br
Time represented as a number.
.I udate
increments once per second.
.br
Usually set to unix time standard: number of seconds since Jan 1, 1970. The
.I date
field will be the unix representation (ascii text) of
.I udate
and setting either will change the other.
.SS VAD VDD
.I read-only, floating point
.br
Voltage read (~10 bits) at the one of the chip's two supply voltages. Range VDD= 2.4V to 10V, VAD=1.5 to 10V.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2437
The
.B DS2437 (3)
is an obsolete version of the
.B DS2438 (3)
battery chip. Current sensing is available, but not implemented. The major advantage compared to the
.B DS2436
is that two voltages can be read, allowing correcting circuit nmeasurements to supply voltage and temperature. A better comparison is the 
.B DS276x
family of chips.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2437.pdf
.br
http://pdfserv.maxim-ic.com/en/an/humsensor.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
