'\"
'\" Copyright (c) 2007 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for owtap -- 1-wire filesystem package
'\" Protocol sniffer for owserver tcp protocol
'\"
'\" Free for all use. No warranty. None. Use at your own risk.
'\"
.TH OWMON 1 2007 "OWTAP Manpage" "One-Wire File System"
.SH NAME
.B owmon
\- Monitor for owserver settings and statistics 
.SH SYNOPSIS
.B owmon
.I \-s
owserver-tcp-port
.br
.SH "DESCRIPTION"
.so man1/description.1so
.SS owserver
.B owserver (1)
is the backend component of the OWFS 1-wire bus control system.
.B owserver (1)
arbitrates access to the bus from multiple client processes. The physical bus is usually connected to a serial or USB port, and other processes connect to
.B owserver (1)
over network sockets (tcp port).
.PP
Frontend clients include a filesystem representation:
.B owfs (1)
, and a webserver:
.B owhttpd (1).
Direct language bindings are also available, e.g:
.B owperl (3).
.PP
There are also many light-weight clients that can only talk to 
.B owserver (1)
and not to the 1-Wire bus directly. They include shell and multiple language modules (perl, Visual Basic, python,...)
.SS owserver protocol
All the
.B owserver (1)
clients use the
.B owserver protocol
for communication. The
.B owserver protocol
is a well documented tcp/ip client/server protocol. Assigned the "well known port" default of 4304. 
.SS owmon
.B owmon (1)
is connects to
.B owserver (1)
and displays the bus structure and contents of the interface, statistics and settings directories.
.SH SPECIFIC OPTIONS
.SS \-s
TCP port or IPaddress:port for
.I owserver
.br
The tcp port (IP:port) for the "upstream" owserver.
.SH EXAMPLE
If
.B owserver (1)
is started:
.br
.B owserver -p 4304 -d /dev/ttyS0
.br
owserver on tcp port 4304 and connects to a physical 1-wire bus on a serial port.
.PP
You can monitor 
.B owserver (1)
with
.br
.B owmon -s 4304 /
.SH PLATFOMS
.B owmon (1)
is a pure
.I Tcl/TK
program and will run wherever
.I Tcl/TK
is available (Windows, Macintosh, Linux, Unix)
.SH LINKS
.SS owserver protocol
http://www.owfs.org/index.php?page=owserver-protocol
.SS Tcl/TK
http://www.tcl.tk
.SH SEE ALSO
.so man1/seealso.1so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
