/*
    OW -- One-Wire filesystem
    version 0.4 7/2/2003

    Function naming scheme:
    OW -- Generic call to interaface
    LI -- LINK commands
    L1 -- 2480B commands
    FS -- filesystem commands
    UT -- utility functions

    Written 2003 Paul H Alfille
        Fuse code based on "fusexmp" {GPL} by Miklos Szeredi, mszeredi@inf.bme.hu
        Serial code based on "xt" {GPL} by David Querbach, www.realtime.bc.ca
        in turn based on "miniterm" by Sven Goldt, goldt@math.tu.berlin.de
    GPL license
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    Other portions based on Dallas Semiconductor Public Domain Kit,
*/

// Not intended to be stand-alone -- called from ow.h
#ifndef OW_REGEX_H			/* tedious wrapper */
#define OW_REGEX_H

#include <regex.h>

void ow_regcomp( regex_t * preg, const char * regex, int cflags ) ;

struct ow_regmatch {
	int number ;
	char ** pre ;
	char ** match ;
	char ** post ;
} ;

int ow_regexec( const regex_t * rex, const char * string, struct ow_regmatch * orm ) ;
void ow_regexec_free( struct ow_regmatch * orm ) ;

#endif							/* OW_REGEX_H */
